/*
Arduino expansion shield example interfacing a button, an analog sensor, an led
and scanning for i2c devices connected to the i2c GPIO of the shield. 


*/
#include <Wire.h>

int ledPin = 13;
int buttonPin = 2;
int analogSensor = A0;
int analogSensorValue = 0;
int buttonState = LOW;
int oldButtonState = HIGH;
char serInput;

void setup()
{
  
    Wire.begin();

  Serial.println("\nI2C Scanner");
  
  pinMode(ledPin, OUTPUT);
  pinMode(buttonPin, INPUT);
  digitalWrite(ledPin, HIGH);
 
  Serial.begin(115200);
}

void loop()
{
  buttonState = digitalRead(buttonPin);
 
  if (Serial.available() > 0)
  {
    serInput = Serial.read();
    Serial.println("Miny, Moe.");
  }
  if (buttonState != oldButtonState)
  {
    if (buttonState == HIGH)
    {
      digitalWrite(ledPin, HIGH);
      Serial.print("Meeny, ");
    }
    else
    {
      digitalWrite(ledPin, LOW);
      Serial.print("Eeny, ");
    }
  }
 
  oldButtonState = buttonState;
  
  
  // i2c scanning
  
  byte error, address;
  int nDevices;

  Serial.println("Scanning...");

  nDevices = 0;
  for(address = 1; address < 127; address++ ) 
  {
    // The i2c_scanner uses the return value of
    // the Write.endTransmisstion to see if
    // a device did acknowledge to the address.
    Wire.beginTransmission(address);
    error = Wire.endTransmission();

    if (error == 0)
    {
      Serial.print("I2C device found at address 0x");
      if (address<16) 
        Serial.print("0");
      Serial.print(address,HEX);
      Serial.println("  !");

      nDevices++;
    }
    else if (error==4) 
    {
      Serial.print("Unknow error at address 0x");
      if (address<16) 
        Serial.print("0");
      Serial.println(address,HEX);
    }    
  }
  if (nDevices == 0)
    Serial.println("No I2C devices found\n");
  else
    Serial.println("done\n");
//delay(1000) // add a delay between scans

//analog sensor 

analogSensorValue = analogRead(analogSensor);
Serial.println(analogSensorValue);

delay(100); //delays entire program readings. 

}
